#include <stdio.h>
#include <dos.h>
#include <fcntl.h>

#define YEAR(t)   (((t & 0xFE00) >> 9) + 1980)
#define MONTH(t)  ((t & 0x01E0) >> 5)
#define DAY(t)	  (t & 0x001F)
#define HOUR(t)   ((t & 0xF800) >> 11)
#define MINUTE(t) ((t & 0x07E0) >> 5)
#define SECOND(t) ((t & 0x001F) << 1)

void main()
  {
    int      handle;
    unsigned short date, time;

    if( _dos_open( "file", O_RDWR, &handle ) != 0 ) {
      printf( "Unable to open file\n" );
    } else {
      printf( "Open succeeded\n" );
      _dos_getftime( handle, &date, &time );
      printf( "The file was last modified on %d/%d/%d",
	      MONTH(date), DAY(date), YEAR(date) );
      printf( " at %.2d:%.2d:%.2d\n",
	      HOUR(time), MINUTE(time), SECOND(time) );
      /* set the time to 12 noon */
      time = (12 << 11) + (0 << 5) + 0;
      _dos_setftime( handle, date, time );
      _dos_getftime( handle, &date, &time );
      printf( "The file was last modified on %d/%d/%d",
	      MONTH(date), DAY(date), YEAR(date) );
      printf( " at %.2d:%.2d:%.2d\n",
	      HOUR(time), MINUTE(time), SECOND(time) );
      _dos_close( handle );
    }
  }
//************ Sample program output ************
//Open succeeded
//The file was last modified on 12/29/1989 at 14:32:46
//The file was last modified on 12/29/1989 at 12:00:00
